﻿using System;
using System.Linq;
using VRM.Integration.FTP.MVI.Messages;
using IMessageBase = VRM.Integration.Servicebus.Core.IMessageBase;
using Logger = VRM.Integration.Servicebus.Core.Logger;
using VRM.Integration.Servicebus.Core;
using MVIMessages = VRM.Integration.Mvi.PersonSearch.Messages;
using VRM.Integration.Mvi.PersonSearch;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VRM.Integration.FTP.MVI;
using VRM.Integration.FTP.MVI.Transformer;
using System.Net;
using System.Runtime.Serialization.Json;

namespace VRM.Integration.FTP.MVI.MVIPersonSearch
{
    public class PersonSearch
    {
      //  MVIResponseTransformer MVITransformer { get; set; }

        public PersonSearch()
        {
          //  MVITransformer = new MVIResponseTransformer();
        }

        public FTPPersonSearchResponse AttendedSearch(FTPPersonSearchRequest request)
        {
            var response = new FTPPersonSearchResponse();
            MVIMessages.RetrieveOrSearchPersonResponse personSearhResponse;

            if (request.IsAttended)
            {
                var searchPersonRequest = new MVIMessages.AttendedSearchRequest(request.FirstName,
                    request.MiddleName, request.FamilyName, request.SocialSecurityNumber, request.BirthDate,
                    request.PhoneNumber, request.UserId, request.UserFirstName, request.UserLastName,
                    request.OrganizationName, request.MessageId);

                personSearhResponse = searchPersonRequest.SendReceive<MVIMessages.RetrieveOrSearchPersonResponse>(MessageProcessType.Remote);
                response = MVIResponseTransformer.TransformRetrieveOrSearchPersonResponse(personSearhResponse);
            }

            return response;
        }

        public FTPPersonSearchResponse UnattendedSearch(FTPPersonSearchRequest request)
        {
            var response = new FTPPersonSearchResponse();
            MVIMessages.RetrieveOrSearchPersonResponse personSearhResponse;

            if (!request.IsAttended)
            {
                var mviOrchestrationRequest = new MVIMessages.RetrieveWithOrchestrationRequest(request.Edipi, request.UserId, request.UserFirstName, request.UserLastName, request.OrganizationName);
                personSearhResponse = mviOrchestrationRequest.SendReceive<MVIMessages.RetrieveOrSearchPersonResponse>(MessageProcessType.Remote);

                response = MVIResponseTransformer.TransformRetrieveOrSearchPersonResponse(personSearhResponse);
            }

            return response;
        }

        public FTPPersonSearchResponse DeterministicSearch(FTPDeterministicSearchRequest request)
        {
            var response = new FTPPersonSearchResponse();
            MVIMessages.RetrieveOrSearchPersonResponse personSearhResponse;

            if (request.SearchType == DeterministicSearchType.Edipi)
            {
                var mviOrchestrationRequest = new MVIMessages.DeterministicSearchRequest(request.EdiPi, MVIMessages.DeterministicSearchType.Edipi, request.BirthDate, request.UserId, request.UserFirstName, request.UserLastName, request.OrganizationName);
                personSearhResponse = mviOrchestrationRequest.SendReceive<MVIMessages.RetrieveOrSearchPersonResponse>(MessageProcessType.Remote);
                response = MVIResponseTransformer.TransformRetrieveOrSearchPersonResponse(personSearhResponse);
            }
            else if (request.SearchType == DeterministicSearchType.SocialSecurity)
            {
                var mviOrchestrationRequest = new MVIMessages.DeterministicSearchRequest(request.SocialSecurityNumber, MVIMessages.DeterministicSearchType.SocialSecurity, request.BirthDate, request.UserId, request.UserFirstName, request.UserLastName, request.OrganizationName);
                personSearhResponse = mviOrchestrationRequest.SendReceive<MVIMessages.RetrieveOrSearchPersonResponse>(MessageProcessType.Remote);
                response = MVIResponseTransformer.TransformRetrieveOrSearchPersonResponse(personSearhResponse);
            }
            else
            {
                response.ExceptionOccured = true;
                response.RawMviExceptionMessage = "Invalid Deterministic Search Type. Request is missing patient SSN and EDIPI";
                return response;
            }
            
            return response;
        }

        public FTPCorrespondingIdsResponse GetCorrespondingIDs(FTPSelectedPersonRequest request)
        {
            var response = new FTPCorrespondingIdsResponse();

            MVIMessages.RetrieveOrSearchPersonResponse personSearhResponse;
            MVIMessages.RetrieveWithOrchestrationRequest mviOrchestrationRequest;

            if (!string.IsNullOrEmpty(request.ICN))
            {
                mviOrchestrationRequest = new MVIMessages.RetrieveWithOrchestrationRequest(request.ICN, request.UserFirstName, request.UserLastName, request.OrganizationName, request.UserId);
            }
            else if (!string.IsNullOrEmpty(request.Edipi))
            {
                mviOrchestrationRequest = new MVIMessages.RetrieveWithOrchestrationRequest(request.Edipi, request.UserId, request.UserFirstName, request.UserLastName, request.OrganizationName);
            }
            else
            {
                response.ExceptionOccured = true;
                response.Message = "Request is missing patient ICN and EDIPI";
                return response;
            }

            personSearhResponse = mviOrchestrationRequest.SendReceive<MVIMessages.RetrieveOrSearchPersonResponse>(MessageProcessType.Remote);

            response = MVIResponseTransformer.TransformRetrieveOrSearchPersonToCorrespondingIdsResponse(personSearhResponse);

            return response;
        }
    }
}
